import java.time.Year;

import javafx.beans.binding.Bindings;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.*;

public class Person {
	private StringProperty firstName ;
	private StringProperty lastName;
	private IntegerProperty yearOfBirth;
	private IntegerProperty age;

	public Person(String first, String last, int yOB) {
		firstName =  new SimpleStringProperty(first);
		lastName = new SimpleStringProperty(last);
		yearOfBirth = new SimpleIntegerProperty(yOB);
		// Berechnung über das Fluent API
//		IntegerBinding ib = yearOfBirth.subtract(Year.now().getValue()).negate();
//		age.bind(ib);
		// Berechnung mithilfe der Klasse Bindings
		age = new SimpleIntegerProperty();
		age.bind(Bindings.subtract(Year.now().getValue(), yearOfBirth));
//		age.bind(Bindings.subtract(10e200, yearOfBirth));
	}

	public final String getFirstName() {
		return firstName.get();
	}
	public final void setFirstName(String first) {
		firstName.set(first);
	}
	public final StringProperty firstNameProperty() {
		return firstName;
	}

	public final String getLastName() {
		return lastName.get();
	}
	public final void setLastName(String last) {
		lastName.set(last);
	}
	public final StringProperty lastNameProperty() {
		return lastName;
	}

	public final IntegerProperty yearOfBirthProperty() {
		return this.yearOfBirth;
	}
	public final int getYearOfBirth() {
		return yearOfBirth.get();
	}
	public final void setYearOfBirth(int yOB) {
		yearOfBirth.set(yOB);
	}

	public final int getAge() {
		return age.get();
	}
	public final void setAge(int a) {
		age.set(a);
	}
	public final IntegerProperty ageProperty() {
		return age;
	}
}
